#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

SYNOINFO="/etc/synoinfo.conf"
SYNOINFO_DEF="/etc.defaults/synoinfo.conf"
SUPPORT_USB_VOLUME=`get_key_value $SYNOINFO_DEF support_usb_volume`
USBSTATION=`get_key_value $SYNOINFO usbstation`
RUN_HA=`get_key_value $SYNOINFO runha`
RUNLEVEL=`runlevel |cut -d' ' -f2`

UpgradeConfig()
{
	Event=$1

	if [ ! -f "/var/.UpgradeBootup" ]; then
		return
	fi

	orgVer="/.old_patch_info/VERSION"
	if [ -f "/.updater" ]; then
		upgType="migrate"
	else
		upgType="upgrade"
	fi

	if [ -f $orgVer ]; then
		/usr/syno/bin/configupdate -c $Event -t $upgType -p $orgVer
	else
		echo "Skip update config because not found ${orgVer}"
	fi
}

make_var_service_tmp()
{
	local DIR=/var/services/tmp
	[ -e $DIR ] && rm -rf $DIR
	local LINK_DIR
	LINK_DIR="$(servicetool --get-alive-volume)"
	if [ $? != 1 ]; then
		mkdir $DIR
		chmod 1777 $DIR
	else
		local TARGET_DIR=$LINK_DIR/@tmp
		[ -d $TARGET_DIR ] || mkdir $TARGET_DIR
		chmod 1777 $TARGET_DIR
		ln -sf $TARGET_DIR $DIR
	fi
}

if [ "$1" = "start" -o "$1" = "" ]; then
	# Clean up printers section in smb.conf
	/usr/syno/bin/synoprint --disable > /dev/null 2>&1

	if [ "$SUPPORT_USB_VOLUME" != "yes" ]; then
		rm /tmp/.db.*
		/usr/syno/bin/synocheckshare
		/usr/syno/sbin/synoquota --migrate
		# finish check share, pause service which required share is not ready
		/usr/syno/sbin/synoservicecfg --check-depend-share-service
		if [ -x "/usr/syno/sbin/synosharesnap" ]; then
			/usr/syno/sbin/synosharesnap misc boot-check
			/usr/syno/sbin/synosharesnap misc metasync
		fi
		rm /tmp/.db.*
		/usr/syno/bin/synocheckiscsitrg
		if [ $RUNLEVEL -eq 1 ]; then
			make_var_service_tmp
			UpgradeConfig "share_ready"
			if [ "$RUN_HA" != "yes" ]; then
				/sbin/initctl emit --no-wait syno.share.ready
			fi
		fi
	fi

	if [ "$RUN_HA" != "yes" ] && [ $RUNLEVEL -eq 1 ] && [ "$SUPPORT_USB_VOLUME" == "yes" ] && [ "$USBSTATION" == "yes" ]; then
		make_var_service_tmp
		UpgradeConfig "share_ready"
		/sbin/initctl emit --no-wait syno.share.ready
	fi

fi

NotifyMyDSLogout()
{
	# MyDS will be logged out due to serial number is changed after migration
	if [ -f "/.updater" ]; then
		/usr/syno/bin/synomyds -n
	fi
}

#Update config before service start
if [ "$1" = "start" -o "$1" = "" ]; then
    if [ -f "/var/.UpgradeBootup" ]; then
        #Sync system notification setting when first time bootup after upgrade
        /usr/syno/bin/notification_utils --gen_category_file enu
        /usr/syno/bin/notification_utils --sync_setting
		NotifyMyDSLogout
    fi
fi

if [ "$1" = "start" -o "$1" = "" ]; then
	/usr/syno/bin/synobootup
fi
